//  Created by Allen Ingling on Wed Mar 31 2004.
//  Copyright (c) 2004 New York University. All rights reserved.


/* HipsViewer */

#import <Cocoa/Cocoa.h>
#import "HipsHelpers.h"
#import <AppKit/AppKit.h>
#include <unistd.h>

@class HipsViewer;

@protocol PlayMovieInterface

- (oneway void)play:(HipsViewer*)viewer;
- (oneway void)playTest:(HipsViewer*)viewer;
- (oneway void)setFramePeriod:(double)periodSecs;
- (oneway void)activateRealtimeDeferred:(BOOL)turnOn;


@end

@interface PlayMovie : NSObject <PlayMovieInterface>
{
	BOOL			isMovieThreadPlaying;
	double			framePeriodSecs;
	BOOL			playThreadPriority;
	//local variables
}
	//method declarations
+ (void)connectWithPorts:(NSArray *)portArray;
- (oneway void)play:(HipsViewer*)viewer;
- (oneway void)playTest:(HipsViewer*)viewer;
- (oneway void)activateRealtimeDeferred:(BOOL)turnOn;			//defers activation of realtime mode until movie play. 
- (oneway void)setFramePeriod:(double)periodSecs;
- (id)init;
	
@end

